/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.checkBoxTree;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeData;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodePanel;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeRenderer;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxTree;

public class CheckBoxNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private static final long serialVersionUID = -8921320784224636657L;
    private final CheckBoxNodeRenderer renderer = new CheckBoxNodeRenderer();
    private final CheckBoxTree theTree;

    public CheckBoxNodeEditor(CheckBoxTree checkBoxTree) {
        this.theTree = checkBoxTree;
    }

    @Override
    public Object getCellEditorValue() {
        CheckBoxNodePanel checkBoxNodePanel = this.renderer.getPanel();
        return checkBoxNodePanel.getData();
    }

    public void addNodeListener(MouseAdapter mouseAdapter) {
        this.renderer.addNodeListener(mouseAdapter);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (!(eventObject instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)eventObject;
        TreePath treePath = this.theTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return false;
        }
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof DefaultMutableTreeNode)) {
            return false;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        return object2 instanceof CheckBoxNodeData;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        Component component = this.renderer.getTreeCellRendererComponent(jTree, object, true, bl2, bl3, n, true);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CheckBoxNodeEditor.this.stopCellEditing()) {
                    CheckBoxNodeEditor.this.fireEditingStopped();
                }
            }
        };
        if (component instanceof CheckBoxNodePanel) {
            CheckBoxNodePanel checkBoxNodePanel = (CheckBoxNodePanel)component;
            checkBoxNodePanel.check.addItemListener(itemListener);
        }
        return component;
    }
}

