/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.checkBoxTree;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.openstreetmap.gui.jmapviewer.AbstractLayer;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.LayerGroup;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeData;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeEditor;
import org.openstreetmap.gui.jmapviewer.checkBoxTree.CheckBoxNodeRenderer;

public class CheckBoxTree
extends JTree {
    private static final long serialVersionUID = 6943401106938034256L;
    private final CheckBoxNodeEditor editor;

    public CheckBoxTree(AbstractLayer abstractLayer) {
        this(new CheckBoxNodeData(abstractLayer));
    }

    public CheckBoxTree(String string) {
        this(new CheckBoxNodeData(string));
    }

    public CheckBoxTree(CheckBoxNodeData checkBoxNodeData) {
        this(new DefaultMutableTreeNode(checkBoxNodeData));
    }

    public CheckBoxTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        super(new DefaultTreeModel(defaultMutableTreeNode));
        CheckBoxNodeRenderer checkBoxNodeRenderer = new CheckBoxNodeRenderer();
        this.setCellRenderer(checkBoxNodeRenderer);
        this.editor = new CheckBoxNodeEditor(this);
        this.setCellEditor(this.editor);
        this.setEditable(true);
        this.getModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)treeModelEvent.getSource();
                Object[] objectArray = treeModelEvent.getChildren();
                DefaultMutableTreeNode defaultMutableTreeNode = objectArray == null || objectArray.length == 0 ? CheckBoxTree.node(defaultTreeModel.getRoot()) : CheckBoxTree.node(objectArray[0]);
                CheckBoxTree.nodeChanged(defaultMutableTreeNode);
                CheckBoxTree.this.repaint();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            }
        });
    }

    public void addNodeListener(MouseAdapter mouseAdapter) {
        this.editor.addNodeListener(mouseAdapter);
    }

    public static void main(String[] stringArray) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(new CheckBoxNodeData("Root", Boolean.TRUE));
        DefaultMutableTreeNode defaultMutableTreeNode2 = CheckBoxTree.add(defaultMutableTreeNode, "Accessibility", true);
        CheckBoxTree.add(defaultMutableTreeNode2, "Move system caret with focus/selection changes", false);
        CheckBoxTree.add(defaultMutableTreeNode2, "Always expand alt text for images", true);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new CheckBoxNodeData("Browsing", null));
        CheckBoxTree.add(defaultMutableTreeNode3, "Notify when downloads complete", true);
        CheckBoxTree.add(defaultMutableTreeNode3, "Disable script debugging", true);
        CheckBoxTree.add(defaultMutableTreeNode3, "Use AutoComplete", true);
        CheckBoxTree.add(defaultMutableTreeNode3, "Browse in a new process", false);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        CheckBoxTree checkBoxTree = new CheckBoxTree(defaultMutableTreeNode);
        ((DefaultMutableTreeNode)checkBoxTree.getModel().getRoot()).add(new DefaultMutableTreeNode(new CheckBoxNodeData("gggg", null)));
        ((DefaultTreeModel)checkBoxTree.getModel()).reload();
        checkBoxTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            }
        });
        JFrame jFrame = new JFrame("CheckBox Tree");
        JScrollPane jScrollPane = new JScrollPane(checkBoxTree);
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(300, 150);
        jFrame.setVisible(true);
    }

    private static Boolean childStatus(DefaultMutableTreeNode defaultMutableTreeNode) {
        Boolean bl = CheckBoxTree.data(defaultMutableTreeNode.getChildAt(0)).isSelected();
        for (int i = 1; i < defaultMutableTreeNode.getChildCount() && bl != null; ++i) {
            if (bl.equals(CheckBoxTree.data(defaultMutableTreeNode.getChildAt(i)).isSelected())) continue;
            return null;
        }
        return bl;
    }

    private static void changeParents(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        if (defaultMutableTreeNode != null && (defaultMutableTreeNode2 = CheckBoxTree.node(defaultMutableTreeNode.getParent())) != null) {
            CheckBoxNodeData checkBoxNodeData = CheckBoxTree.data(defaultMutableTreeNode2);
            Boolean bl = CheckBoxTree.childStatus(defaultMutableTreeNode2);
            if (bl != null && !bl.equals(checkBoxNodeData.isSelected())) {
                checkBoxNodeData.setSelected(bl);
                CheckBoxTree.changeParents(defaultMutableTreeNode2);
            }
        }
    }

    private static void nodeChanged(DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode != null) {
            CheckBoxTree.changeParents(defaultMutableTreeNode);
            CheckBoxTree.setChildrens(defaultMutableTreeNode, CheckBoxTree.data(defaultMutableTreeNode).isSelected());
        }
    }

    private static void setChildrens(DefaultMutableTreeNode defaultMutableTreeNode, Boolean bl) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = CheckBoxTree.node(defaultMutableTreeNode.getChildAt(i));
            if (CheckBoxTree.data(defaultMutableTreeNode2).isSelected().equals(CheckBoxTree.data(defaultMutableTreeNode).isSelected())) continue;
            CheckBoxTree.data(defaultMutableTreeNode2).setSelected(CheckBoxTree.data(defaultMutableTreeNode).isSelected());
            CheckBoxTree.setChildrens(defaultMutableTreeNode2, bl);
        }
    }

    public DefaultMutableTreeNode rootNode() {
        return CheckBoxTree.node(this.getModel().getRoot());
    }

    public LayerGroup rootLayer() {
        return (LayerGroup)this.rootData().getAbstractLayer();
    }

    public CheckBoxNodeData rootData() {
        return CheckBoxTree.data(this.rootNode());
    }

    private static DefaultMutableTreeNode node(Object object) {
        return (DefaultMutableTreeNode)object;
    }

    public static CheckBoxNodeData data(DefaultMutableTreeNode defaultMutableTreeNode) {
        return defaultMutableTreeNode == null ? null : (CheckBoxNodeData)defaultMutableTreeNode.getUserObject();
    }

    private static CheckBoxNodeData data(Object object) {
        return CheckBoxTree.data(CheckBoxTree.node(object));
    }

    private static DefaultMutableTreeNode add(DefaultMutableTreeNode defaultMutableTreeNode, String string, boolean bl) {
        CheckBoxNodeData checkBoxNodeData = new CheckBoxNodeData(string, bl);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(checkBoxNodeData);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return defaultMutableTreeNode2;
    }

    public static CheckBoxNodeData createNodeData(AbstractLayer abstractLayer) {
        return new CheckBoxNodeData(abstractLayer);
    }

    public static DefaultMutableTreeNode createNode(AbstractLayer abstractLayer) {
        return new DefaultMutableTreeNode(CheckBoxTree.createNodeData(abstractLayer));
    }

    public Layer addLayer(String string) {
        Layer layer = new Layer(string);
        this.addLayer(layer);
        return layer;
    }

    public DefaultMutableTreeNode addLayer(AbstractLayer abstractLayer) {
        if (abstractLayer != null) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            if (abstractLayer.getParent() == null) {
                this.rootLayer().add(abstractLayer);
                defaultMutableTreeNode = this.rootNode();
            } else {
                defaultMutableTreeNode = this.searchNode(abstractLayer.getParent());
                if (defaultMutableTreeNode == null) {
                    defaultMutableTreeNode = this.addLayer(abstractLayer.getParent());
                }
            }
            return this.add(defaultMutableTreeNode, abstractLayer);
        }
        return null;
    }

    public DefaultMutableTreeNode add(DefaultMutableTreeNode defaultMutableTreeNode, AbstractLayer abstractLayer) {
        abstractLayer.setVisible(CheckBoxTree.data(defaultMutableTreeNode).isSelected());
        DefaultMutableTreeNode defaultMutableTreeNode2 = CheckBoxTree.createNode(abstractLayer);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        ((DefaultTreeModel)this.getModel()).reload();
        return defaultMutableTreeNode2;
    }

    public DefaultMutableTreeNode searchNode(AbstractLayer abstractLayer) {
        return this.searchNode(this.rootNode(), abstractLayer);
    }

    public DefaultMutableTreeNode searchNode(DefaultMutableTreeNode defaultMutableTreeNode, AbstractLayer abstractLayer) {
        CheckBoxNodeData checkBoxNodeData = CheckBoxTree.data(defaultMutableTreeNode);
        if (checkBoxNodeData.getAbstractLayer() == abstractLayer) {
            return defaultMutableTreeNode;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount() && defaultMutableTreeNode2 == null; ++i) {
            defaultMutableTreeNode2 = this.searchNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), abstractLayer);
        }
        return defaultMutableTreeNode2;
    }
}

