/*
 * Decompiled with CFR 0.152.
 */
package se.kodapan.osm.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import se.kodapan.osm.domain.Node;
import se.kodapan.osm.domain.OsmObject;
import se.kodapan.osm.domain.OsmObjectVisitor;
import se.kodapan.osm.domain.root.NotLoadedException;

public class Way
extends OsmObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected List<Node> nodes;

    @Override
    public <R> R accept(OsmObjectVisitor<R> osmObjectVisitor) {
        return osmObjectVisitor.visit(this);
    }

    public boolean isPolygon() {
        if (!this.isLoaded()) {
            throw new NotLoadedException(this);
        }
        return this.getNodes().size() > 2 && this.getNodes().get(0).equals(this.getNodes().get(this.getNodes().size() - 1));
    }

    public void addNode(Node node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>(50);
        }
        this.nodes.add(node);
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<Node> list) {
        this.nodes = list;
    }

    public Node getFirst() {
        if (this.nodes.size() > 0) {
            return this.nodes.get(0);
        }
        return null;
    }

    public Node getLast() {
        if (this.nodes.size() > 0) {
            return this.nodes.get(this.nodes.size() - 1);
        }
        return null;
    }

    public void reverse() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.nodes) {
            arrayList.add(0, node);
        }
        this.nodes = arrayList;
    }

    public void addBefore(Way way) {
        List<Node> list = way.getNodes();
        for (Node node : this.nodes) {
            list.add(node);
        }
        this.nodes = list;
    }

    public void addAfter(Way way) {
        for (Node node : way.getNodes()) {
            this.nodes.add(node);
        }
    }

    @Override
    public String toString() {
        return "Way{" + super.toString() + "nodes.size=" + (this.nodes == null ? "null" : Integer.valueOf(this.nodes.size())) + '}';
    }
}

