/*
 * Decompiled with CFR 0.152.
 */
package se.kodapan.osm.services;

import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;

public class HttpService {
    private long minimumMillisecondsDelayBetweenRequests = 0L;
    private long previousRequestTimestamp = 0L;
    private ClientConnectionManager cm;
    private HttpClient httpClient;
    private String defaultUserAgent;
    private String userAgent = this.defaultUserAgent = "Unnamed instance of " + this.getClass().getName() + ", https://github.com/karlwettin/osm-common/";

    public void open() throws Exception {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        this.cm = new ThreadSafeClientConnManager((HttpParams)new BasicHttpParams(), schemeRegistry);
        this.httpClient = new DefaultHttpClient(this.cm, (HttpParams)new BasicHttpParams());
    }

    public void setUserAgent(HttpRequest httpRequest) {
        if (this.defaultUserAgent.equals(this.userAgent)) {
            throw new NullPointerException("HTTP header User-Agent not set! See se.kodapan.osm.services.HttpService#setUserAgent");
        }
        httpRequest.setHeader("User-Agent", this.userAgent);
    }

    public void close() throws Exception {
    }

    public void leniency() throws Exception {
        long l;
        while ((l = this.previousRequestTimestamp + this.minimumMillisecondsDelayBetweenRequests - System.currentTimeMillis()) > 0L) {
            Thread.sleep(l);
        }
        this.previousRequestTimestamp = System.currentTimeMillis();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public long getMinimumMillisecondsDelayBetweenRequests() {
        return this.minimumMillisecondsDelayBetweenRequests;
    }

    public void setMinimumMillisecondsDelayBetweenRequests(long l) {
        this.minimumMillisecondsDelayBetweenRequests = l;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

